/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ipc.sim.process.impl;

import com.cisco.pt.IPAddress;
import com.cisco.pt.impl.IPCCall;
import com.cisco.pt.impl.IPCMessageLTV;
import com.cisco.pt.impl.IPCResponseLTV;
import com.cisco.pt.ipc.IPCError;
import com.cisco.pt.ipc.IPCFactory;
import com.cisco.pt.ipc.enums.AcsServerType;
import com.cisco.pt.ipc.sim.process.AcsServerProcess;
import com.cisco.pt.ipc.sim.process.impl.ProcessImpl;
import com.cisco.pt.ptmp.PacketTracerSession;

public class AcsServerProcessImpl
extends ProcessImpl
implements AcsServerProcess {
    public AcsServerProcessImpl(IPCFactory ipcFactory, PacketTracerSession packetTracerSession, IPCMessageLTV accessMessage) {
        super(ipcFactory, packetTracerSession, accessMessage);
    }

    public boolean addToUserMap(String userName, String description, String password) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("addToUserMap");
        newCall.addStringParameter(userName);
        newCall.addStringParameter(description);
        newCall.addStringParameter(password);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: AcsServerProcessImpl.addToUserMap");
        }
        return returnMessage.getBoolValue();
    }

    public void deleteFromUserMap(String userName) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("deleteFromUserMap");
        newCall.addStringParameter(userName);
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    public boolean addToClientMap(IPAddress hostIp, AcsServerType serverType, String name, String keyStr) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("addToClientMap");
        newCall.addIPAddressParameter(hostIp);
        newCall.addIntParameter(serverType.getIntValue());
        newCall.addStringParameter(name);
        newCall.addStringParameter(keyStr);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: AcsServerProcessImpl.addToClientMap");
        }
        return returnMessage.getBoolValue();
    }

    public void deleteFromClientMap(IPAddress hostIp, AcsServerType serverType) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("deleteFromClientMap");
        newCall.addIPAddressParameter(hostIp);
        newCall.addIntParameter(serverType.getIntValue());
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    public void enableACSServerService(boolean status) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("enableACSServerService");
        newCall.addBoolParameter(status);
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    public boolean isEnabled() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("isEnabled");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: AcsServerProcessImpl.isEnabled");
        }
        return returnMessage.getBoolValue();
    }
}

